/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.actorbar;

import com.quantumdata.sct.dao.impl.DeviceTypeDAO;
import com.quantumdata.sct.dao.impl.ModelDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.DeviceTypeVO;
import com.quantumdata.sct.dao.vo.ModelVO;
import com.quantumdata.sct.dao.vo.UnitVO;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityarea.ActivityArea;
import com.quantumdata.sct.gui.activityarea.ModelSelectActivityArea;
import com.quantumdata.sct.gui.activityarea.UnitSelectActivityArea;
import com.quantumdata.sct.gui.actorbar.AbstractActorBar;
import com.quantumdata.sct.gui.actorbar.NamedActorBarButton;
import com.quantumdata.sct.gui.common.SCTCheckBox;
import com.quantumdata.sct.gui.wizard.IBODialog;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class NamedActorBar
extends AbstractActorBar {
    private ComplianceTesterToolUI m_toolUI;
    IPersistable[] persistables = null;
    JPopupMenu fileMenu;
    JPopupMenu devMenu;
    SCTCheckBox autoStep;

    public NamedActorBar(ComplianceTesterToolUI complianceTesterToolUI) {
        super(4, (short)1);
        this.m_toolUI = complianceTesterToolUI;
        this.fileMenu = new JPopupMenu("File");
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("NewFile");
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Update");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("UpdateFile");
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("DeleteFile");
        this.fileMenu.add(jMenuItem);
        this.devMenu = new JPopupMenu("Select Product");
        this.initProductMenu(this.devMenu);
        SCTSelection.instance().setNamedActorBar(this);
    }

    public void addButtons() {
        ModelSelectActivityArea modelSelectActivityArea = new ModelSelectActivityArea(this.m_toolUI);
        UnitSelectActivityArea unitSelectActivityArea = new UnitSelectActivityArea(this.m_toolUI);
        this.buttons[0] = new NamedActorBarButton("File");
        Dimension dimension = new Dimension(70, 36);
        this.buttons[0].setSize(dimension);
        this.buttons[0].setPreferredSize(dimension);
        this.buttons[0].addActionListener(this);
        this.buttons[1] = new NamedActorBarButton("Product");
        this.buttons[1].addActionListener(this);
        this.buttons[2] = new NamedActorBarButton("Model:CDF", modelSelectActivityArea);
        this.buttons[2].addActionListener(this);
        this.buttons[2].setEnabled(true);
        this.buttons[3] = new NamedActorBarButton("Unit:Device", unitSelectActivityArea);
        this.buttons[3].setEnabled(false);
        this.buttons[3].addActionListener(this);
        SCTSelection.instance().setIBODialog(new IBODialog(this.m_toolUI));
        SCTSelection.instance().setAutoStep(true);
        this.buttons[0].addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                NamedActorBar.this.fileMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.buttons[1].addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                NamedActorBar.this.devMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public void addAutoStep() {
        this.autoStep = new SCTCheckBox("<HTML>Auto<br>Step</HTML>");
        this.autoStep.setSelected(true);
        this.autoStep.addActionListener(this);
        this.add(this.autoStep);
    }

    public ActivityArea getActivityArea(int n) {
        if (this.buttons == null || this.buttons[n] == null) {
            return null;
        }
        return ((NamedActorBarButton)this.buttons[n]).getActivityArea();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.autoStep) {
            SCTSelection.instance().setAutoStep(this.autoStep.isSelected());
        }
        if (actionEvent.getSource() == this.buttons[2]) {
            this.m_toolUI.setActivityArea(this.getActivityArea(2));
        } else if (actionEvent.getSource() == this.buttons[3]) {
            this.m_toolUI.setActivityArea(this.getActivityArea(3));
        } else if (actionEvent.getActionCommand().equals("NewFile")) {
            SCTSelection.instance().getIBODialog().newCurrent();
        } else if (actionEvent.getActionCommand().equals("UpdateFile")) {
            SCTSelection.instance().getIBODialog().updateCurrent();
        } else if (actionEvent.getActionCommand().equals("DeleteFile")) {
            SCTSelection.instance().getIBODialog().deleteCurrent();
        }
        for (int i = 0; i < this.persistables.length; ++i) {
            if (!actionEvent.getActionCommand().equals("Product" + i)) continue;
            SCTSelection.instance().setDeviceID(this.persistables[i].getId().toString());
            SCTSelection.instance().setUutType(((DeviceTypeVO)this.persistables[i]).getUutType());
            this.buttons[2].setEnabled(true);
            this.m_toolUI.setActivityArea(this.getActivityArea(2));
            ((ModelSelectActivityArea)this.getActivityArea(2)).getModelSelectionFolder().setDeviceTypeComboBox((DeviceTypeVO)this.persistables[i]);
            this.m_toolUI.setTopPanelSelected(2);
        }
    }

    public void setDevice(String string) {
        try {
            DeviceTypeDAO deviceTypeDAO = (DeviceTypeDAO)XMLDAOFactory.getDeviceTypeDAO();
            DeviceTypeVO deviceTypeVO = (DeviceTypeVO)deviceTypeDAO.read(string);
            this.m_toolUI.setStatusPanelAttribute(0, "Product= " + deviceTypeVO.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(String string) {
        try {
            ModelDAO modelDAO = (ModelDAO)XMLDAOFactory.getModelDAO();
            ModelVO modelVO = (ModelVO)modelDAO.read(string);
            this.m_toolUI.setStatusPanelAttribute(1, "Model:CDF= " + modelVO.getNumber() + ":" + modelVO.getDescription());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setUser(String string) {
    }

    public void setUnit(String string) {
        if (string != null) {
            this.m_toolUI.setStatusPanelAttribute(2, "Unit:Device= " + string);
        }
    }

    public void setUnit(UnitVO unitVO) {
        this.setUnit(unitVO.getSerialNumber());
    }

    public void setUnitEnabled(boolean bl) {
        this.buttons[3].setEnabled(bl);
    }

    public void setSelectedButton(int n) {
        if (n > 1) {
            this.setLastSelected(n);
        }
    }

    private void initProductMenu(JPopupMenu jPopupMenu) {
        DeviceTypeDAO deviceTypeDAO = null;
        try {
            deviceTypeDAO = (DeviceTypeDAO)XMLDAOFactory.getDeviceTypeDAO();
            this.persistables = deviceTypeDAO.findByAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < this.persistables.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(((DeviceTypeVO)this.persistables[i]).getName());
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("Product" + i);
            jPopupMenu.add(jMenuItem);
        }
        SCTSelection.instance().setDeviceID(this.persistables[0].getId().toString());
        SCTSelection.instance().setUutType(((DeviceTypeVO)this.persistables[0]).getUutType());
    }
}

